/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.gui.GuiSubscribe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.controls.Button;
import net.montoyo.wd.client.gui.controls.CheckBox;
import net.montoyo.wd.client.gui.controls.ControlGroup;
import net.montoyo.wd.client.gui.controls.Label;
import net.montoyo.wd.client.gui.controls.List;
import net.montoyo.wd.client.gui.controls.TextField;
import net.montoyo.wd.client.gui.controls.UpgradeGroup;
import net.montoyo.wd.client.gui.loading.FillControl;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.net.server.SMessageScreenCtrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;

public class GuiScreenConfig
extends WDScreen {
    private final TileEntityScreen tes;
    private final BlockSide side;
    private NameUUIDPair owner;
    private NameUUIDPair[] friends;
    private int friendRights;
    private int otherRights;
    private Rotation rotation = Rotation.ROT_0;
    private float aspectRatio;
    private boolean waitingAC;
    private int acFailTicks = -1;
    private final ArrayList<NameUUIDPair> acResults = new ArrayList();
    private boolean adding;
    @FillControl
    private Label lblOwner;
    @FillControl
    private List lstFriends;
    @FillControl
    private Button btnAdd;
    @FillControl
    private TextField tfFriend;
    @FillControl
    private TextField tfResX;
    @FillControl
    private TextField tfResY;
    @FillControl
    private ControlGroup grpFriends;
    @FillControl
    private ControlGroup grpOthers;
    @FillControl
    private CheckBox boxFSetUrl;
    @FillControl
    private CheckBox boxFClick;
    @FillControl
    private CheckBox boxFFriends;
    @FillControl
    private CheckBox boxFOthers;
    @FillControl
    private CheckBox boxFUpgrades;
    @FillControl
    private CheckBox boxFResolution;
    @FillControl
    private CheckBox boxOSetUrl;
    @FillControl
    private CheckBox boxOClick;
    @FillControl
    private CheckBox boxOUpgrades;
    @FillControl
    private CheckBox boxOResolution;
    @FillControl
    private Button btnSetRes;
    @FillControl
    private UpgradeGroup ugUpgrades;
    @FillControl
    private Button btnChangeRot;
    @FillControl
    private CheckBox cbLockRatio;
    @FillControl
    private CheckBox cbAutoVolume;
    private CheckBox[] friendBoxes;
    private CheckBox[] otherBoxes;

    public GuiScreenConfig(TileEntityScreen tes, BlockSide side, NameUUIDPair[] friends, int fr, int or) {
        this.tes = tes;
        this.side = side;
        this.friends = friends;
        this.friendRights = fr;
        this.otherRights = or;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.loadFrom(new ResourceLocation("webdisplays", "gui/screencfg.json"));
        this.friendBoxes = new CheckBox[]{this.boxFResolution, this.boxFUpgrades, this.boxFOthers, this.boxFFriends, this.boxFClick, this.boxFSetUrl};
        this.boxFResolution.setUserdata(32);
        this.boxFUpgrades.setUserdata(16);
        this.boxFOthers.setUserdata(8);
        this.boxFFriends.setUserdata(4);
        this.boxFClick.setUserdata(2);
        this.boxFSetUrl.setUserdata(1);
        this.otherBoxes = new CheckBox[]{this.boxOResolution, this.boxOUpgrades, this.boxOClick, this.boxOSetUrl};
        this.boxOResolution.setUserdata(32);
        this.boxOUpgrades.setUserdata(16);
        this.boxOClick.setUserdata(2);
        this.boxOSetUrl.setUserdata(1);
        TileEntityScreen.Screen scr = this.tes.getScreen(this.side);
        if (scr != null) {
            this.owner = scr.owner;
            this.rotation = scr.rotation;
            this.tfResX.setText("" + scr.resolution.x);
            this.tfResY.setText("" + scr.resolution.y);
            this.aspectRatio = (float)scr.resolution.x / (float)scr.resolution.y;
            this.ugUpgrades.setUpgrades(scr.upgrades);
            this.cbAutoVolume.setChecked(scr.autoVolume);
        }
        if (this.owner == null) {
            this.owner = new NameUUIDPair("???", UUID.randomUUID());
        }
        this.lblOwner.setLabel(this.lblOwner.getLabel() + ' ' + this.owner.name);
        for (NameUUIDPair f : this.friends) {
            this.lstFriends.addElementRaw(f.name, f);
        }
        this.lstFriends.updateContent();
        this.updateRights(this.friendRights, this.friendRights, this.friendBoxes, true);
        this.updateRights(this.otherRights, this.otherRights, this.otherBoxes, true);
        this.updateMyRights();
        this.updateRotationStr();
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_194007_a((SoundEvent)WebDisplays.INSTANCE.soundScreenCfg, (float)1.0f, (float)1.0f));
    }

    private void updateRotationStr() {
        this.btnChangeRot.setLabel(I18n.func_135052_a((String)("webdisplays.gui.screencfg.rot" + this.rotation.getAngleAsInt()), (Object[])new Object[0]));
    }

    private void addFriend(String name) {
        if (!name.isEmpty()) {
            this.requestAutocomplete(name, true);
            this.tfFriend.setDisabled(true);
            this.adding = true;
            this.waitingAC = true;
        }
    }

    private void clickSetRes() {
        TileEntityScreen.Screen scr = this.tes.getScreen(this.side);
        if (scr == null) {
            return;
        }
        try {
            int x = Integer.parseInt(this.tfResX.getText());
            int y = Integer.parseInt(this.tfResY.getText());
            if (x < 1 || y < 1) {
                throw new NumberFormatException();
            }
            if (x != scr.resolution.x || y != scr.resolution.y) {
                WebDisplays.NET_HANDLER.sendToServer((IMessage)SMessageScreenCtrl.vec2(this.tes, this.side, 5, new Vector2i(x, y)));
            }
        }
        catch (NumberFormatException ex) {
            this.tfResX.setText("" + scr.resolution.x);
            this.tfResY.setText("" + scr.resolution.y);
        }
        this.btnSetRes.setDisabled(true);
    }

    @GuiSubscribe
    public void onClick(Button.ClickEvent ev) {
        if (ev.getSource() == this.btnAdd && !this.waitingAC) {
            this.addFriend(this.tfFriend.getText().trim());
        } else if (ev.getSource() == this.btnSetRes) {
            this.clickSetRes();
        } else if (ev.getSource() == this.btnChangeRot) {
            Rotation[] rots = Rotation.values();
            WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessageScreenCtrl(this.tes, this.side, rots[(this.rotation.ordinal() + 1) % rots.length]));
        }
    }

    @GuiSubscribe
    public void onEnterPressed(TextField.EnterPressedEvent ev) {
        if (ev.getSource() == this.tfFriend && !this.waitingAC) {
            this.addFriend(ev.getText().trim());
        } else if (!(ev.getSource() != this.tfResX && ev.getSource() != this.tfResY || this.btnSetRes.isDisabled())) {
            this.clickSetRes();
        }
    }

    @GuiSubscribe
    public void onAutocomplete(TextField.TabPressedEvent ev) {
        if (ev.getSource() == this.tfFriend && !this.waitingAC && !ev.getBeginning().isEmpty()) {
            if (this.acResults.isEmpty()) {
                this.waitingAC = true;
                this.requestAutocomplete(ev.getBeginning(), false);
            } else {
                NameUUIDPair pair = this.acResults.remove(0);
                this.tfFriend.setText(pair.name);
            }
        } else if (ev.getSource() == this.tfResX) {
            this.tfResX.setFocused(false);
            this.tfResY.focus();
            this.tfResY.getMcField().func_146196_d();
            this.tfResY.getMcField().func_146199_i(this.tfResY.getText().length());
        }
    }

    @GuiSubscribe
    public void onTextChanged(TextField.TextChangedEvent ev) {
        if (ev.getSource() == this.tfResX || ev.getSource() == this.tfResY) {
            for (int i = 0; i < ev.getNewContent().length(); ++i) {
                if (Character.isDigit(ev.getNewContent().charAt(i))) continue;
                ((TextField)ev.getSource()).setText(ev.getOldContent());
                return;
            }
            if (this.cbLockRatio.isChecked()) {
                if (ev.getSource() == this.tfResX) {
                    try {
                        float val = Integer.parseInt(ev.getNewContent());
                        this.tfResY.setText("" + (int)(val /= this.aspectRatio));
                    }
                    catch (NumberFormatException val) {}
                } else {
                    try {
                        float val = Integer.parseInt(ev.getNewContent());
                        this.tfResX.setText("" + (int)(val *= this.aspectRatio));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            this.btnSetRes.setDisabled(false);
        }
    }

    @GuiSubscribe
    public void onRemovePlayer(List.EntryClick ev) {
        if (ev.getSource() == this.lstFriends) {
            WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessageScreenCtrl(this.tes, this.side, (NameUUIDPair)ev.getUserdata(), true));
        }
    }

    @GuiSubscribe
    public void onCheckboxChanged(CheckBox.CheckedEvent ev) {
        if (this.isFriendCheckbox((CheckBox)ev.getSource())) {
            int flag = (Integer)((CheckBox)ev.getSource()).getUserdata();
            this.friendRights = ev.isChecked() ? (this.friendRights |= flag) : (this.friendRights &= ~flag);
            this.requestSync();
        } else if (this.isOtherCheckbox((CheckBox)ev.getSource())) {
            int flag = (Integer)((CheckBox)ev.getSource()).getUserdata();
            this.otherRights = ev.isChecked() ? (this.otherRights |= flag) : (this.otherRights &= ~flag);
            this.requestSync();
        } else if (ev.getSource() == this.cbLockRatio && ev.isChecked()) {
            try {
                int x = Integer.parseInt(this.tfResX.getText());
                int y = Integer.parseInt(this.tfResY.getText());
                this.aspectRatio = (float)x / (float)y;
            }
            catch (NumberFormatException ex) {
                this.cbLockRatio.setChecked(false);
            }
        } else if (ev.getSource() == this.cbAutoVolume) {
            WebDisplays.NET_HANDLER.sendToServer((IMessage)SMessageScreenCtrl.autoVol(this.tes, this.side, ev.isChecked()));
        }
    }

    @GuiSubscribe
    public void onRemoveUpgrade(UpgradeGroup.ClickEvent ev) {
        WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessageScreenCtrl(this.tes, this.side, ev.getMouseOverStack()));
    }

    public boolean isFriendCheckbox(CheckBox cb) {
        return Arrays.stream(this.friendBoxes).anyMatch(fb -> cb == fb);
    }

    public boolean isOtherCheckbox(CheckBox cb) {
        return Arrays.stream(this.otherBoxes).anyMatch(ob -> cb == ob);
    }

    public boolean hasFriend(NameUUIDPair f) {
        return Arrays.stream(this.friends).anyMatch(f::equals);
    }

    @Override
    public void onAutocompleteResult(NameUUIDPair[] pairs) {
        this.waitingAC = false;
        if (this.adding) {
            if (!this.hasFriend(pairs[0])) {
                WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessageScreenCtrl(this.tes, this.side, pairs[0], false));
            }
            this.tfFriend.setDisabled(false);
            this.tfFriend.clear();
            this.tfFriend.focus();
            this.adding = false;
        } else {
            this.acResults.clear();
            this.acResults.addAll(Arrays.asList(pairs));
            NameUUIDPair pair = this.acResults.remove(0);
            this.tfFriend.setText(pair.name);
        }
    }

    @Override
    public void onAutocompleteFailure() {
        this.waitingAC = false;
        this.acResults.clear();
        this.acFailTicks = 0;
        this.tfFriend.setTextColor(-65536);
        if (this.adding) {
            this.tfFriend.setDisabled(false);
            this.adding = false;
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.acFailTicks >= 0 && ++this.acFailTicks >= 10) {
            this.acFailTicks = -1;
            this.tfFriend.setTextColor(0xE0E0E0);
        }
    }

    public void updateFriends(NameUUIDPair[] friends) {
        boolean diff = false;
        if (friends.length != this.friends.length) {
            diff = true;
        } else {
            for (NameUUIDPair pair : friends) {
                if (this.hasFriend(pair)) continue;
                diff = true;
                break;
            }
        }
        if (diff) {
            this.friends = friends;
            this.lstFriends.clearRaw();
            for (NameUUIDPair pair : friends) {
                this.lstFriends.addElementRaw(pair.name, pair);
            }
            this.lstFriends.updateContent();
        }
    }

    private int updateRights(int current, int newVal, CheckBox[] boxes, boolean force) {
        if (force || current != newVal) {
            CheckBox[] checkBoxArray = boxes;
            int n = checkBoxArray.length;
            for (int i = 0; i < n; ++i) {
                CheckBox box;
                int flag = (Integer)(box = checkBoxArray[i]).getUserdata();
                box.setChecked((newVal & flag) != 0);
            }
            if (!force) {
                Log.info("Screen check boxes were updated", new Object[0]);
                this.abortSync();
            }
        }
        return newVal;
    }

    public void updateFriendRights(int rights) {
        this.friendRights = this.updateRights(this.friendRights, rights, this.friendBoxes, false);
    }

    public void updateOtherRights(int rights) {
        this.otherRights = this.updateRights(this.otherRights, rights, this.otherBoxes, false);
    }

    @Override
    protected void sync() {
        WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessageScreenCtrl(this.tes, this.side, this.friendRights, this.otherRights));
        Log.info("Sent sync packet", new Object[0]);
    }

    public void updateMyRights() {
        int myRights;
        NameUUIDPair me = new NameUUIDPair(this.field_146297_k.field_71439_g.func_146103_bH());
        boolean clientIsOwner = false;
        if (me.equals(this.owner)) {
            myRights = 255;
            clientIsOwner = true;
        } else {
            myRights = this.hasFriend(me) ? this.friendRights : this.otherRights;
        }
        this.grpFriends.setDisabled(!clientIsOwner);
        boolean flag = (myRights & 4) == 0;
        this.lstFriends.setDisabled(flag);
        this.tfFriend.setDisabled(flag);
        this.btnAdd.setDisabled(flag);
        flag = (myRights & 8) == 0;
        this.grpOthers.setDisabled(flag);
        flag = (myRights & 0x20) == 0;
        this.tfResX.setDisabled(flag);
        this.tfResY.setDisabled(flag);
        this.btnChangeRot.setDisabled(flag);
        if (flag) {
            this.btnSetRes.setDisabled(true);
        }
        flag = (myRights & 0x10) == 0;
        this.ugUpgrades.setDisabled(flag);
        this.cbAutoVolume.setDisabled(flag);
    }

    public void updateResolution(Vector2i res) {
        this.aspectRatio = (float)res.x / (float)res.y;
        this.tfResX.setText("" + res.x);
        this.tfResY.setText("" + res.y);
        this.btnSetRes.setDisabled(true);
    }

    public void updateRotation(Rotation rot) {
        this.rotation = rot;
        this.updateRotationStr();
    }

    public void updateAutoVolume(boolean av) {
        this.cbAutoVolume.setChecked(av);
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return bp.equals((Object)this.tes.func_174877_v()) && side == this.side;
    }

    @Override
    @Nullable
    public String getWikiPageName() {
        ItemStack is = this.ugUpgrades.getMouseOverUpgrade();
        if (is != null) {
            if (is.func_77973_b() instanceof WDItem) {
                return ((WDItem)is.func_77973_b()).getWikiName(is);
            }
            return null;
        }
        return "Screen_Configurator";
    }
}

